/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.epherolib.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Stream;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public abstract class WorldBasedStorage {
    protected final Gson GSON;
    protected final Path basePath;

    public WorldBasedStorage(class_5218 resource, MinecraftServer server, String path) {
        this(server.method_27050(resource).resolve(path));
    }

    public WorldBasedStorage(Path path) {
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                Files.createDirectories(path, new FileAttribute[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.basePath = path;
        this.GSON = this.buildGson(new GsonBuilder());
    }

    protected abstract Gson buildGson(GsonBuilder var1);

    public Path getBasePath() {
        return this.basePath;
    }

    public void writeTagToFile(class_2520 tag, Path path) throws IOException {
        try (FileWriter writer = new FileWriter(path.toFile());){
            this.GSON.toJson((JsonElement)class_2509.field_11560.method_29146((DynamicOps)JsonOps.INSTANCE, tag), (Appendable)writer);
        }
    }

    public class_2520 readTagFromFile(Path path) throws IOException {
        try (FileReader reader = new FileReader(path.toFile());){
            JsonElement jsonElement = (JsonElement)this.GSON.fromJson((Reader)reader, JsonElement.class);
            class_2520 class_25202 = (class_2520)JsonOps.INSTANCE.convertTo((DynamicOps)class_2509.field_11560, jsonElement);
            return class_25202;
        }
    }

    public Stream<Path> getFiles() throws IOException {
        return Files.walk(this.basePath, new FileVisitOption[0]);
    }
}

