/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaCropBlock;
import com.epherical.croptopia.items.CropItem;
import com.epherical.croptopia.items.SeedItem;
import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.FoodConstructor;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

public class FarmlandCrop
implements ItemConvertibleWithPlural,
BlockConvertible {
    public static final List<FarmlandCrop> FARMLAND_CROPS = new ArrayList<FarmlandCrop>();
    private final String name;
    private final String dropName;
    private final boolean plural;
    private final TagCategory tagCategory;
    private final FoodConstructor registry;
    private class_1792 cropItem;
    private class_2248 cropBlock;
    private class_1792 seedItem;
    private final class_6862<class_1959> biomes;

    public FarmlandCrop(String cropName, boolean isPlural, TagCategory category, FoodConstructor registry, class_6862<class_1959> biomes) {
        this(cropName, cropName, isPlural, category, registry, biomes);
    }

    public FarmlandCrop(String cropName, String dropName, boolean isPlural, TagCategory category, FoodConstructor registry, class_6862<class_1959> biomes) {
        Objects.requireNonNull(category);
        Content.BLOCK_REGISTER.reg(this::registerBlock);
        Content.ITEM_REGISTER.reg(this::registerItem);
        this.name = cropName;
        this.dropName = dropName;
        this.plural = isPlural;
        this.tagCategory = category;
        this.biomes = biomes;
        this.registry = registry;
        FARMLAND_CROPS.add(this);
    }

    @Override
    public class_2248 asBlock() {
        return this.cropBlock;
    }

    @Override
    public String name() {
        return this.dropName;
    }

    @Override
    public boolean hasPlural() {
        return this.plural;
    }

    public class_1792 method_8389() {
        return this.cropItem;
    }

    public TagCategory getTagCategory() {
        return this.tagCategory;
    }

    public class_1792 getSeedItem() {
        return this.seedItem;
    }

    public static List<FarmlandCrop> copy() {
        return FARMLAND_CROPS;
    }

    public void registerBlock(RegisterFunction<class_2248> register) {
        class_2960 location = CroptopiaMod.createIdentifier(this.name + "_crop");
        class_5321 key = class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)location), (class_2960)location);
        this.cropBlock = register.register(location, () -> new CroptopiaCropBlock(CroptopiaMod.createCropSettings().method_63500(key)));
        CroptopiaMod.cropBlocks.add(this.asBlock());
    }

    public void registerItem(RegisterFunction<class_1792> register) {
        class_2960 itemLocation = CroptopiaMod.createIdentifier(this.dropName);
        class_5321 itemKey = class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)itemLocation), (class_2960)itemLocation);
        this.cropItem = register.register(itemLocation, () -> {
            if (this.registry == null) {
                return new CropItem(CroptopiaMod.createGroup().method_63686(itemKey));
            }
            return new CropItem(CroptopiaMod.createGroup().method_19265(FoodConstructor.createFood(this.registry)).method_63686(itemKey));
        });
        if (this.name().equals("vanilla")) {
            class_2960 seedItemLocation = CroptopiaMod.createIdentifier(this.name + "_seeds");
            class_5321 seedItemKey = class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)seedItemLocation), (class_2960)seedItemLocation);
            this.seedItem = register.register(seedItemLocation, () -> new SeedItem(this.cropBlock, CroptopiaMod.createGroup().method_63686(seedItemKey), this.biomes));
        } else {
            class_2960 seedItemLocation = CroptopiaMod.createIdentifier(this.name + "_seed");
            class_5321 seedItemKey = class_5321.method_29179((class_5321)class_5321.method_29180((class_2960)seedItemLocation), (class_2960)seedItemLocation);
            this.seedItem = (class_1792)class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)seedItemLocation, (Object)((Object)new SeedItem(this.asBlock(), CroptopiaMod.createGroup().method_63686(seedItemKey), this.biomes)));
        }
        CroptopiaMod.cropItems.add(this.method_8389());
        CroptopiaMod.seeds.add(this.seedItem);
    }
}

